package org.codefilarete.stalactite.sql.sqlite;

import java.util.stream.Collectors;

import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSQL;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Sorter;
import org.codefilarete.tool.function.Predicates;

/**
 * 
 * @author Guillaume Mary
 */
public class SQLiteDMLGenerator extends DMLGenerator {
	
	public SQLiteDMLGenerator(ParameterBinderIndex<Column, ParameterBinder> columnBinderRegistry, Sorter<Column> columnSorter, DMLNameProviderFactory dmlNameProvider) {
		super(columnBinderRegistry, columnSorter, dmlNameProvider);
	}
	
	@Override
	public <T extends Table<T>> ColumnParameterizedSQL<T> buildInsert(Iterable<? extends Column<T, ?>> columns) {
		// removing autogenerated keys from sql because SQLite doesn't support it
		columns = Iterables.stream(columns).filter(Predicates.not(Column::isAutoGenerated)).collect(Collectors.toList());
		return super.buildInsert(columns);
	}
}
